/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.dot.schemaspy.edge;

import java.util.HashSet;
import java.util.Set;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.schemaspy.output.dot.schemaspy.Edge;
import org.schemaspy.output.dot.schemaspy.edge.Edges;

public class RelatedEdges
implements Edges {
    private final TableColumn column;
    private final Table targetTable;
    private final boolean includeExcluded;
    private final boolean includeImplied;

    public RelatedEdges(TableColumn column, Table targetTable, boolean includeExcluded, boolean includeImplied) {
        this.column = column;
        this.targetTable = targetTable;
        this.includeExcluded = includeExcluded;
        this.includeImplied = includeImplied;
    }

    public Set<Edge> unique() {
        boolean implied;
        HashSet<Edge> relatedConnectors = new HashSet<Edge>();
        if (!this.includeExcluded && this.column.isExcluded()) {
            return relatedConnectors;
        }
        for (TableColumn parentColumn : this.column.getParents()) {
            Table parentTable = parentColumn.getTable();
            if (this.targetTable != null && parentTable != this.targetTable || this.targetTable == null && !this.includeExcluded && parentColumn.isExcluded() || (implied = this.column.getParentConstraint(parentColumn).isImplied()) && !this.includeImplied) continue;
            relatedConnectors.add(new Edge(parentColumn, this.column, implied));
        }
        for (TableColumn childColumn : this.column.getChildren()) {
            Table childTable = childColumn.getTable();
            if (this.targetTable != null && childTable != this.targetTable || this.targetTable == null && !this.includeExcluded && childColumn.isExcluded() || (implied = this.column.getChildConstraint(childColumn).isImplied()) && !this.includeImplied) continue;
            relatedConnectors.add(new Edge(this.column, childColumn, implied));
        }
        return relatedConnectors;
    }
}

