/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.service;

import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.schemaspy.input.dbms.service.ColumnService;
import org.schemaspy.input.dbms.service.IndexService;
import org.schemaspy.input.dbms.service.SqlService;
import org.schemaspy.input.dbms.service.TableService;
import org.schemaspy.input.dbms.service.helper.ExportForeignKey;
import org.schemaspy.input.dbms.service.helper.ImportForeignKey;
import org.schemaspy.input.dbms.service.helper.RemoteTableIdentifier;
import org.schemaspy.input.dbms.xml.ForeignKeyMeta;
import org.schemaspy.input.dbms.xml.TableColumnMeta;
import org.schemaspy.input.dbms.xml.TableMeta;
import org.schemaspy.model.Database;
import org.schemaspy.model.ForeignKeyConstraint;
import org.schemaspy.model.LogicalRemoteTable;
import org.schemaspy.model.RemoteTable;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TableService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SqlService sqlService;
    private final boolean exportedKeys;
    private final boolean multiSchemas;
    private final Pattern include;
    private final Pattern exclude;
    private final Properties dbProperties;
    private final ColumnService columnService;
    private final IndexService indexService;

    public TableService(SqlService sqlService, boolean exportedKeys, boolean multiSchemas, Pattern include, Pattern exclude, Properties dbProperties, ColumnService columnService, IndexService indexService) {
        this.sqlService = Objects.requireNonNull(sqlService);
        this.exportedKeys = exportedKeys;
        this.multiSchemas = multiSchemas;
        this.include = include;
        this.exclude = exclude;
        this.dbProperties = dbProperties;
        this.columnService = Objects.requireNonNull(columnService);
        this.indexService = Objects.requireNonNull(indexService);
    }

    public void gatheringTableDetails(Database database, Table table) throws SQLException {
        this.columnService.gatherColumns(table);
        this.indexService.gatherIndexes(database, table);
    }

    public void connectForeignKeys(Database db, Table table, Map<String, Table> tables) {
        ResultSet rs;
        LOGGER.trace("Connecting foreign keys to {}", (Object)table.getFullName());
        try {
            rs = this.sqlService.getDatabaseMetaData().getImportedKeys(table.getCatalog(), table.getSchema(), table.getName());
            try {
                ArrayList<ImportForeignKey> importedKeys = new ArrayList<ImportForeignKey>();
                while (rs.next()) {
                    importedKeys.add(new ImportForeignKey.Builder().fromImportKeysResultSet(rs).build());
                }
                for (ImportForeignKey importedKey : importedKeys) {
                    this.addForeignKey(db, table, importedKey, tables);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException sqlex) {
            LOGGER.warn("Failed to getImportedKeys", (Throwable)sqlex);
        }
        if ((table.getSchema() != null || table.getCatalog() != null) && this.exportedKeys) {
            try {
                rs = this.sqlService.getDatabaseMetaData().getExportedKeys(table.getCatalog(), table.getSchema(), table.getName());
                try {
                    ArrayList<ExportForeignKey> exportedKeys = new ArrayList<ExportForeignKey>();
                    while (rs.next()) {
                        exportedKeys.add(new ExportForeignKey.Builder().fromExportedKeysResultSet(rs).build());
                    }
                    for (ExportForeignKey exportedKey : exportedKeys) {
                        if (!TableService.isRemote((Table)table, (ExportForeignKey)exportedKey)) continue;
                        this.addRemoteTable(db, RemoteTableIdentifier.from((ExportForeignKey)exportedKey), table.getSchema());
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (SQLException sqlex) {
                LOGGER.warn("Failed to getExportedKeys", (Throwable)sqlex);
            }
        }
    }

    private static boolean isRemote(Table table, ExportForeignKey foreignKey) {
        return !String.valueOf(table.getCatalog()).equals(String.valueOf(foreignKey.getFkTableCat())) || !String.valueOf(table.getSchema()).equals(String.valueOf(foreignKey.getFkTableSchema()));
    }

    private void connectForeignKeysRemoteTable(Database db, RemoteTable remoteTable, Map<String, Table> tables) throws SQLException {
        block10: {
            LOGGER.trace("Connecting foreign keys to {}", (Object)remoteTable.getFullName());
            try (ResultSet rs = this.sqlService.getDatabaseMetaData().getImportedKeys(remoteTable.getCatalog(), remoteTable.getSchema(), remoteTable.getName());){
                while (rs.next()) {
                    ImportForeignKey foreignKey = new ImportForeignKey.Builder().fromImportKeysResultSet(rs).build();
                    if (!remoteTable.getBaseContainer().equals(foreignKey.getPkTableSchema()) && !remoteTable.getBaseContainer().equals(foreignKey.getPkTableCat())) continue;
                    this.addForeignKey(db, (Table)remoteTable, foreignKey, tables);
                }
            }
            catch (SQLException sqlExc) {
                if (remoteTable.isLogical()) break block10;
                if (this.multiSchemas) {
                    throw sqlExc;
                }
                LOGGER.warn("Couldn't resolve foreign keys for remote table '{}'", (Object)remoteTable.getFullName(), (Object)sqlExc);
            }
        }
    }

    protected void addForeignKey(Database db, Table table, ImportForeignKey foreignKey, Map<String, Table> tables) throws SQLException {
        if (Objects.isNull(foreignKey.getFkName()) || this.shouldExclude(db.getName(), foreignKey)) {
            return;
        }
        ForeignKeyConstraint foreignKeyConstraint = Optional.ofNullable((ForeignKeyConstraint)table.getForeignKeysMap().get((Object)foreignKey.getFkName())).orElseGet(() -> {
            ForeignKeyConstraint fkc = new ForeignKeyConstraint(table, foreignKey.getFkName(), foreignKey.getUpdateRule().intValue(), foreignKey.getDeleteRule().intValue());
            table.getForeignKeysMap().put(foreignKey.getFkName(), (Object)fkc);
            return fkc;
        });
        TableColumn childColumn = table.getColumn(foreignKey.getFkColumnName());
        if (childColumn != null) {
            TableColumn parentColumn;
            String childContainer;
            foreignKeyConstraint.addChildColumn(childColumn);
            Table parentTable = tables.get(foreignKey.getPkTableName());
            String parentContainer = Stream.of(foreignKey.getPkTableSchema(), foreignKey.getPkTableCat(), db.getName()).filter(Objects::nonNull).findFirst().orElse(null);
            String string = childContainer = table instanceof RemoteTable ? ((RemoteTable)table).getBaseContainer() : table.getContainer();
            if (parentTable == null || !childContainer.equals(parentContainer)) {
                LOGGER.debug("Adding remote table {}", (Object)Table.getFullName((String)db.getName(), (String)foreignKey.getPkTableCat(), (String)foreignKey.getPkTableSchema(), (String)foreignKey.getPkTableName()));
                parentTable = this.addRemoteTable(db, RemoteTableIdentifier.from((ImportForeignKey)foreignKey), table.getContainer());
            }
            if ((parentColumn = parentTable.getColumn(foreignKey.getPkColumnName())) != null) {
                foreignKeyConstraint.addParentColumn(parentColumn);
                childColumn.addParent(parentColumn, foreignKeyConstraint);
                parentColumn.addChild(childColumn, foreignKeyConstraint);
            } else {
                LOGGER.warn("Couldn't add FK '{}' to table '{}' - Column '{}' doesn't exist in table '{}'", new Object[]{foreignKeyConstraint.getName(), table.getName(), foreignKey.getPkColumnName(), parentTable});
            }
        } else {
            LOGGER.warn("Couldn't add FK '{}' to table '{}' - Column '{}' doesn't exist", new Object[]{foreignKeyConstraint.getName(), table.getName(), foreignKey.getFkColumnName()});
        }
    }

    private boolean shouldExclude(String databaseName, ImportForeignKey foreignKey) {
        if (!this.include.matcher(foreignKey.getPkTableName()).matches() || this.exclude.matcher(foreignKey.getPkTableName()).matches()) {
            LOGGER.debug("Ignoring {} referenced by FK {}", (Object)Table.getFullName((String)databaseName, (String)foreignKey.getPkTableCat(), (String)foreignKey.getPkTableSchema(), (String)foreignKey.getPkTableName()), (Object)foreignKey.getFkName());
            return true;
        }
        return false;
    }

    protected long fetchNumRows(Database db, Table table) {
        if (table.isView() || table.isRemote()) {
            return -1L;
        }
        SQLException originalFailure = null;
        String sql = this.dbProperties.getProperty("selectRowCountSql");
        if (sql != null) {
            try {
                return this.fetchNumRows(db, table, sql);
            }
            catch (SQLException sqlException) {
                originalFailure = sqlException;
                LOGGER.debug("Failed to fetch number of rows for '{}' using custom query: '{}'", new Object[]{table.getFullName(), sql, sqlException});
            }
        }
        try {
            return this.fetchNumRows(db, table, "count(*)", false);
        }
        catch (SQLException try2Exception) {
            LOGGER.debug("Failed to fetch number of rows for '{}' using built-in query with 'count(*)'", (Object)table.getFullName(), (Object)try2Exception);
            try {
                return this.fetchNumRows(db, table, "count(1)", false);
            }
            catch (SQLException try3Exception) {
                if (!table.isLogical()) {
                    if (originalFailure != null) {
                        LOGGER.warn("Failed to fetch number of rows for '{}' using custom query: '{}'", new Object[]{table.getFullName(), sql, originalFailure});
                    }
                    LOGGER.warn("Failed to fetch number of rows for '{}' using built-in query with 'count(*)'", (Object)table.getFullName(), (Object)try2Exception);
                    LOGGER.warn("Failed to fetch number of rows for '{}' using built-in query with 'count(1)'", (Object)table.getFullName(), (Object)try3Exception);
                }
                return -1L;
            }
        }
    }

    private long fetchNumRows(Database database, Table table, String sql) throws SQLException {
        try (PreparedStatement stmt = this.sqlService.prepareStatement(sql, database, table.getName());
             ResultSet rs = stmt.executeQuery();){
            if (rs.next()) {
                long l = rs.getLong("row_count");
                return l;
            }
            throw new SQLException("Empty ResultSet");
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected long fetchNumRows(Database db, Table table, String clause, boolean forceQuotes) throws SQLException {
        StringBuilder sql = new StringBuilder("select ");
        sql.append(clause);
        sql.append(" from ");
        sql.append(this.sqlService.getQualifiedTableName(table.getCatalog(), table.getSchema(), table.getName(), forceQuotes));
        LOGGER.trace("Fetch number of rows using sql: '{}'", (Object)sql);
        try (PreparedStatement stmt = this.sqlService.prepareStatement(sql.toString());){
            long l;
            block19: {
                ResultSet rs;
                block17: {
                    long l2;
                    block18: {
                        rs = stmt.executeQuery();
                        try {
                            if (!rs.next()) break block17;
                            l2 = rs.getLong(1);
                            if (rs == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return l2;
                }
                l = -1L;
                if (rs == null) break block19;
                rs.close();
            }
            return l;
        }
        catch (SQLException exc) {
            if (forceQuotes) {
                throw exc;
            }
            return this.fetchNumRows(db, table, clause, true);
        }
    }

    public Table addRemoteTable(Database db, RemoteTableIdentifier remoteTableIdentifier, String schema) throws SQLException {
        return this.addRemoteTable(db, remoteTableIdentifier, schema, false);
    }

    public Table addLogicalRemoteTable(Database db, RemoteTableIdentifier remoteTableIdentifier, String schema) throws SQLException {
        return this.addRemoteTable(db, remoteTableIdentifier, schema, true);
    }

    private Table addRemoteTable(Database db, RemoteTableIdentifier remoteTableIdentifier, String baseContainer, boolean logical) throws SQLException {
        String fullName = db.getRemoteTableKey(remoteTableIdentifier.getCatalogName(), remoteTableIdentifier.getSchemaName(), remoteTableIdentifier.getTableName());
        RemoteTable remoteTable = (RemoteTable)db.getRemoteTablesMap().get(fullName);
        if (remoteTable == null) {
            LOGGER.debug("Creating remote table {}", (Object)fullName);
            if (logical) {
                remoteTable = new LogicalRemoteTable(db, remoteTableIdentifier, baseContainer);
            } else {
                remoteTable = new RemoteTable(db, remoteTableIdentifier, baseContainer);
                this.columnService.gatherColumns((Table)remoteTable);
            }
            LOGGER.debug("Adding remote table {}", (Object)fullName);
            db.getRemoteTablesMap().put(fullName, remoteTable);
            this.connectForeignKeysRemoteTable(db, remoteTable, db.getLocals());
        }
        return remoteTable;
    }

    public void connect(Database db, Table table, TableMeta tableMeta, Map<String, Table> tables) {
        for (TableColumnMeta colMeta : tableMeta.getColumns()) {
            TableColumn col = table.getColumn(colMeta.getName());
            if (col != null) {
                for (ForeignKeyMeta fk : colMeta.getForeignKeys()) {
                    Table parent;
                    if (fk.getRemoteCatalog() != null || fk.getRemoteSchema() != null) {
                        try {
                            parent = this.addLogicalRemoteTable(db, RemoteTableIdentifier.from((ForeignKeyMeta)fk), table.getContainer());
                            this.addColumnIfMissing(parent, fk.getColumnName());
                        }
                        catch (SQLException exc) {
                            parent = null;
                            LOGGER.debug("Failed to addRemoteTable '{}.{}.{}'", new Object[]{fk.getRemoteCatalog(), fk.getRemoteSchema(), fk.getTableName(), exc});
                        }
                    } else {
                        parent = tables.get(fk.getTableName());
                    }
                    if (parent != null) {
                        TableColumn parentColumn = parent.getColumn(fk.getColumnName());
                        if (parentColumn == null) {
                            LOGGER.warn("Undefined column '{}.{}' referenced by '{}.{}' in XML metadata", new Object[]{parent.getName(), fk.getColumnName(), col.getTable(), col});
                            continue;
                        }
                        1 unused = new /* Unavailable Anonymous Inner Class!! */;
                        if (parentColumn.isPrimary()) continue;
                        LOGGER.warn("Assuming '{}.{}' is a primary key due to being referenced by '{}.{}'", new Object[]{parentColumn.getTable(), parentColumn, col.getTable(), col});
                        parent.setPrimaryColumn(parentColumn);
                        continue;
                    }
                    LOGGER.warn("Undefined table '{}' referenced by '{}.{}' in XML metadata", new Object[]{fk.getTableName(), table.getName(), col.getName()});
                }
                continue;
            }
            LOGGER.warn("Undefined column '{}.{}' in XML metadata", (Object)table.getName(), (Object)colMeta.getName());
        }
    }

    private void addColumnIfMissing(Table parent, String columnName) {
        if (!parent.getColumnsMap().containsKey((Object)columnName)) {
            TableColumn tableColumn = new TableColumn(parent);
            tableColumn.setName(columnName);
            parent.getColumnsMap().put(columnName, (Object)tableColumn);
        }
    }

    public void gatherTableIds(Database db) throws SQLException {
        String sql = this.dbProperties.getProperty("selectTableIdsSql");
        if (sql != null) {
            try (PreparedStatement stmt = this.sqlService.prepareStatement(sql, db, null);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String tableName = rs.getString("table_name");
                    Table table = (Table)db.getLocals().get(tableName);
                    if (table == null) continue;
                    table.setId(rs.getObject("table_id"));
                }
            }
            catch (SQLException sqlException) {
                LOGGER.warn("Failed to fetch table ids using SQL '{}'", (Object)sql, (Object)sqlException);
            }
        }
    }

    public void gatherTableComments(Database db) {
        String sql = this.dbProperties.getProperty("selectTableCommentsSql");
        if (sql != null) {
            try (PreparedStatement stmt = this.sqlService.prepareStatement(sql, db, null);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String tableName = rs.getString("table_name");
                    Table table = (Table)db.getLocals().get(tableName);
                    if (table == null) continue;
                    table.setComments(rs.getString("comments"));
                }
            }
            catch (SQLException sqlException) {
                LOGGER.warn("Failed to retrieve table comments using SQL '{}'", (Object)sql, (Object)sqlException);
            }
        }
    }

    public void gatherTableColumnComments(Database db) {
        String sql = this.dbProperties.getProperty("selectColumnCommentsSql");
        if (sql != null) {
            try (PreparedStatement stmt = this.sqlService.prepareStatement(sql, db, null);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    TableColumn column;
                    String tableName = rs.getString("table_name");
                    Table table = (Table)db.getLocals().get(tableName);
                    if (table == null || (column = table.getColumn(rs.getString("column_name"))) == null) continue;
                    column.setComments(rs.getString("comments"));
                }
            }
            catch (SQLException sqlException) {
                LOGGER.warn("Failed to retrieve column comments using SQL '{}'", (Object)sql, (Object)sqlException);
            }
        }
    }
}

